/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.projectvibrantjourneys.common.world.features;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.AquaticFeatures;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class HotSpringsFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState AIR = Blocks.f_50627_.m_49966_();

    public HotSpringsFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        BlockPos blockpos = pContext.m_159777_();
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        RandomSource randomsource = pContext.m_225041_();
        ChunkGenerator generator = pContext.m_159775_();
        if (blockpos.m_123342_() <= worldgenlevel.m_141937_() + 4) {
            return false;
        }
        blockpos = blockpos.m_6625_(4);
        boolean[] aboolean = new boolean[2048];
        int i = randomsource.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = randomsource.m_188500_() * 6.0 + 3.0;
            double d1 = randomsource.m_188500_() * 4.0 + 2.0;
            double d2 = randomsource.m_188500_() * 6.0 + 3.0;
            double d3 = randomsource.m_188500_() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = randomsource.m_188500_() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = randomsource.m_188500_() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState blockstate1 = Blocks.f_49990_.m_49966_();
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int k = 0; k < 16; ++k) {
                for (int l2 = 0; l2 < 8; ++l2) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + k) * 8 + l2] && (k1 < 15 && aboolean[((k1 + 1) * 16 + k) * 8 + l2] || k1 > 0 && aboolean[((k1 - 1) * 16 + k) * 8 + l2] || k < 15 && aboolean[(k1 * 16 + k + 1) * 8 + l2] || k > 0 && aboolean[(k1 * 16 + (k - 1)) * 8 + l2] || l2 < 7 && aboolean[(k1 * 16 + k) * 8 + l2 + 1] || l2 > 0 && aboolean[(k1 * 16 + k) * 8 + (l2 - 1)]);
                    if (!flag) continue;
                    BlockState blockstate3 = worldgenlevel.m_8055_(blockpos.m_7918_(k1, l2, k));
                    if (l2 >= 4 && blockstate3.m_278721_()) {
                        return false;
                    }
                    if (l2 >= 4 || blockstate3.m_280296_() || worldgenlevel.m_8055_(blockpos.m_7918_(k1, l2, k)) == blockstate1) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 8; ++i3) {
                    BlockPos blockpos1;
                    if (!aboolean[(l1 * 16 + i2) * 8 + i3] || !this.canReplaceBlock(worldgenlevel.m_8055_(blockpos1 = blockpos.m_7918_(l1, i3, i2)))) continue;
                    boolean flag1 = i3 >= 4;
                    worldgenlevel.m_7731_(blockpos1, flag1 ? AIR : blockstate1, 2);
                    if (!flag1) continue;
                    worldgenlevel.m_186460_(blockpos1, AIR.m_60734_(), 0);
                    this.m_159739_(worldgenlevel, blockpos1);
                }
            }
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int j3 = 0; j3 < 16; ++j3) {
                for (int l3 = 0; l3 < 8; ++l3) {
                    BlockState blockstate;
                    boolean flag2;
                    boolean bl = flag2 = !aboolean[(j2 * 16 + j3) * 8 + l3] && (j2 < 15 && aboolean[((j2 + 1) * 16 + j3) * 8 + l3] || j2 > 0 && aboolean[((j2 - 1) * 16 + j3) * 8 + l3] || j3 < 15 && aboolean[(j2 * 16 + j3 + 1) * 8 + l3] || j3 > 0 && aboolean[(j2 * 16 + (j3 - 1)) * 8 + l3] || l3 < 7 && aboolean[(j2 * 16 + j3) * 8 + l3 + 1] || l3 > 0 && aboolean[(j2 * 16 + j3) * 8 + (l3 - 1)]);
                    if (!flag2 || l3 >= 4 && randomsource.m_188503_(2) == 0 || !(blockstate = worldgenlevel.m_8055_(blockpos.m_7918_(j2, l3, j3))).m_280296_() || blockstate.m_204336_(BlockTags.f_144288_)) continue;
                    BlockPos blockpos3 = blockpos.m_7918_(j2, l3, j3);
                    if (!worldgenlevel.m_6425_(blockpos3.m_7494_()).m_205070_(FluidTags.f_13131_)) {
                        if (worldgenlevel.m_46859_(blockpos3.m_7494_()) || worldgenlevel.m_8055_(blockpos3.m_7494_()).m_247087_()) {
                            boolean flag4;
                            BlockState perimeterBlock = this.getRandomPerimeterBlock(randomsource);
                            worldgenlevel.m_7731_(blockpos3, perimeterBlock, 2);
                            boolean bl2 = flag4 = randomsource.m_188501_() < 0.45f;
                            if (flag4) {
                                worldgenlevel.m_7731_(blockpos3.m_7494_(), this.getAmethyst(randomsource), 2);
                            }
                        }
                    } else {
                        boolean flag5;
                        BlockState innerBlock = this.getRandomInnerBlock(randomsource);
                        worldgenlevel.m_7731_(blockpos3, innerBlock, 2);
                        boolean bl3 = flag5 = randomsource.m_188501_() < 0.3f;
                        if (flag5) {
                            Optional watergrassFeature = worldgenlevel.m_9598_().m_175515_(Registries.f_256911_).m_203636_(AquaticFeatures.f_194930_);
                            watergrassFeature.ifPresent(feature -> ((ConfiguredFeature)feature.m_203334_()).m_224953_(worldgenlevel, generator, randomsource, blockpos3.m_7494_()));
                        }
                    }
                    this.m_159739_(worldgenlevel, blockpos3);
                }
            }
        }
        return true;
    }

    private BlockState getRandomPerimeterBlock(RandomSource randomSource) {
        float random = randomSource.m_188501_();
        if (random < 0.3f) {
            return Blocks.f_50069_.m_49966_();
        }
        if (random < 0.5f) {
            return Blocks.f_50652_.m_49966_();
        }
        if (random < 0.7f) {
            return Blocks.f_50079_.m_49966_();
        }
        return Blocks.f_50599_.m_49966_();
    }

    private BlockState getRandomInnerBlock(RandomSource randomSource) {
        float random = randomSource.m_188501_();
        if (random < 0.3f) {
            return Blocks.f_50069_.m_49966_();
        }
        if (random < 0.5f) {
            return Blocks.f_50652_.m_49966_();
        }
        if (random < 0.7f) {
            return Blocks.f_50079_.m_49966_();
        }
        if (random < 0.83f) {
            return Blocks.f_50450_.m_49966_();
        }
        return Blocks.f_50228_.m_49966_();
    }

    private boolean canReplaceBlock(BlockState pState) {
        return !pState.m_204336_(BlockTags.f_144287_);
    }

    private BlockState getAmethyst(RandomSource randomSource) {
        float random = randomSource.m_188501_();
        if (random <= 0.2f) {
            return Blocks.f_152492_.m_49966_();
        }
        if (random <= 0.2f) {
            return Blocks.f_152493_.m_49966_();
        }
        if (random <= 0.2f) {
            return Blocks.f_152494_.m_49966_();
        }
        return Blocks.f_152495_.m_49966_();
    }
}

